/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.mssClient;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoxGraphic {
    private int graphicType = 5;
    private GenModel mssClientModel;
    private GenModel pciFeModel;
    private GenModel systemModel;
    private JdmBrowser jdmBrowser;
    private Vector modelList;
    private Vector remoteStatusList;
    private Vector proxyStatusList;
    private static final String PropertiesFile = "properties/mssClient.txt";
    private static String layoutKey = "Client.layout.scheme";
    private static String fractKey = "Client.layout.fractions";
    private static final String bundleName = "ibm.nways.mssClient.Resources";
    private static final String cookiePath = "ibm.nways.mssClient.WCDefault";
    private static final int RASID = 19;
    private static final int RASSUB = 27;

    protected BoxGraphic(JdmBrowser jdmBrowser, int n) {
        this.graphicType = n;
        if (this.graphicType == 4) {
            layoutKey = "DomainClient.layout.scheme";
            fractKey = "DomainClient.layout.fractions";
        }
        this.modelList = new Vector();
        this.remoteStatusList = new Vector();
        this.proxyStatusList = new Vector();
        this.jdmBrowser = jdmBrowser;
    }

    protected GraphicPanel getGraphicPanel() {
        Object object;
        Properties properties;
        Serializable serializable;
        GraphicContainer graphicContainer = new GraphicContainer();
        Vector vector = new Vector();
        try {
            serializable = new URL(this.jdmBrowser.getDocumentBase(), PropertiesFile);
            if (RAS.isEnabled(19, 27)) {
                RAS.trace(19, 27, this, "getGraphicPanel()", "DocumentBase = " + this.jdmBrowser.getDocumentBase());
            }
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            properties = null;
            RAS.logException(19, 27, this, "getGraphicPanel()", exception);
            RAS.logError(19, 27, this, "getGraphicPanel()", "EXCEPTION_GETTING_PROPERTIES", (Object)(String.valueOf(this.jdmBrowser.getDocumentBase()) + PropertiesFile));
        }
        JdmLayout jdmLayout = (JdmLayout)this.jdmBrowser.getLayout();
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
            if (RAS.isEnabled(19, 27)) {
                RAS.trace(19, 27, this, "getGraphicPanel()", "Layout = " + serializable);
            }
            int n = (Integer)serializable;
            jdmLayout.setScheme(n);
            String string = (String)((Hashtable)properties).get(fractKey);
            object = new StringTokenizer(string);
            float[] fArray = new float[((StringTokenizer)object).countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < fArray.length && ((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                try {
                    fArray[n2] = Float.valueOf(string2).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    RAS.logException(19, 27, this, "getGraphicPanel()", (Exception)numberFormatException);
                    RAS.logError(19, 27, this, "getGraphicPanel()", "EXCEPTION_CALCULATING_FRACTIONS", (Object)numberFormatException);
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
            }
        }
        this.getBoxInfo();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName);
        String string = this.graphicType == 4 ? "fer827x.gif" : "fe827x.gif";
        CookieTray cookieTray = new CookieTray(bundleName, new Point(2, 18), string, "", this.jdmBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
        graphicContainer.add((GraphicContainer)cookieTray);
        serializable = new GraphicHelp((BrowserApplet)this.jdmBrowser, new Point(2, 0), new HelpRef((Object)this));
        graphicContainer.add((GraphicComponent)serializable);
        if (this.graphicType == 5) {
            try {
                vector = this.pciFeModel.getRestOfInfo("Config", "default", null, null);
                ModelInfo modelInfo = (ModelInfo)vector.elementAt(0);
                String string3 = modelInfo.get("Config.Fe827xPCIAdapType").toString();
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, this, "getGraphicPanel", "PCI slot #1 type=" + string3);
                }
                WidgetCookie widgetCookie = this.getPciImage(string3, 1, modelInfo);
                cookieTray.AddWidget(widgetCookie);
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, this, "getGraphicPanel", "No PCI Port #1");
                }
                RAS.logException(19, 27, this, "getGraphicPanel()", exception);
                object = new Integer(1);
                WidgetCookie widgetCookie = this.getPciImage(((Integer)object).toString(), 1, null);
                cookieTray.AddWidget(widgetCookie);
                exception.printStackTrace();
            }
        }
        GraphicPanel graphicPanel = new GraphicPanel((GraphicHandler)this.jdmBrowser, (Component)graphicContainer);
        return graphicPanel;
    }

    private void getBoxInfo() {
        block10: {
            try {
                this.pciFeModel = (GenModel)this.mssClientModel.getComponent("PciMssClient");
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, this, "getBoxInfo", "Got pciFe");
                }
                if (this.pciFeModel == null) {
                    if (RAS.isEnabled(19, 27)) {
                        RAS.trace(19, 27, this, "getBoxInfo", "Got pci Fe is not NULL");
                    }
                } else if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, this, "getBoxInfo", "pci Fe is NULL!!!!");
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 27, this, "getBoxInfo", exception);
            }
            try {
                this.systemModel = (GenModel)this.mssClientModel.getComponent("System");
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, this, "getBoxInfo", "Got system model");
                    return;
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 27, this, "getBoxInfo", exception);
                if (!RAS.isEnabled(19, 27)) break block10;
                RAS.trace(19, 27, this, "getBoxInfo", "Exception getting Graphic System Model");
            }
        }
    }

    protected void setMssClientModel(GenModel genModel) {
        this.mssClientModel = genModel;
    }

    private WidgetCookie getPciImage(String string, int n, ModelInfo modelInfo) {
        WidgetCookie widgetCookie;
        Integer n2 = new Integer(string);
        int n3 = n2;
        switch (n3) {
            case 1: {
                widgetCookie = this.AtmPCI(modelInfo, n);
                widgetCookie.SetFlyover("Unknown");
                break;
            }
            case 2: {
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, this, "getPciImage", "Expected PCI type =" + string);
                }
                widgetCookie = this.AtmPCI(modelInfo, n);
                break;
            }
            default: {
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, this, "getPciImage", "Unexpected PCI type =" + string);
                }
                widgetCookie = this.AtmPCI(modelInfo, n);
                widgetCookie.SetFlyover("Unknown");
            }
        }
        return widgetCookie;
    }

    private WidgetCookie AtmPCI(ModelInfo modelInfo, int n) {
        WidgetCookie widgetCookie = new WidgetCookie("atm", bundleName, modelInfo, cookiePath, this.pciFeModel, this.jdmBrowser, 16, "ibm.nways.mssClient.eui.PciAdapterPanel");
        return widgetCookie;
    }
}

